package game;

import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;


public class LevelData {
	
	private HashMap<String, RoomData> rooms;
	
	private String levelName;
	private String levelStartRoomName;
	private int levelStartX;
	private int levelStartY;
	private BackgroundMusic bgm;
	private boolean shouldHaveRain;
	private boolean loadingComplete = false;
	private boolean usingDefaultMusic = false;
	private String fileName;
	private boolean loadedFromFiles;
	
	
	private boolean levelLoadGotError = false;

	private PurgeThread purgeThread = null;
	
	
	private static class LevelLoadThread extends Thread {
		
		private BufferedReader in = null;
		private LevelData levelData = null;
		private boolean fromFiles = false;
		private String fileToLoad = null;
		private PonyPanel ponyPanel;
		
		public LevelLoadThread(BufferedReader theIn, LevelData theLevelData, boolean isFromFiles, String fileName, PonyPanel thePanel) {
			in = theIn;
			levelData = theLevelData;
			fromFiles = isFromFiles;
			fileToLoad = fileName;
			ponyPanel = thePanel;
		}
		
		public void run() {
			
			
			try {
				
				
				String inputter = in.readLine();
				
				if(inputter.equalsIgnoreCase("file")) {
					fromFiles = true;
				}
				levelData.fileName = fileToLoad;
				levelData.loadedFromFiles = fromFiles;
				levelData.shouldHaveRain = false;
				
				do {
					
					if(inputter.contains("#"))
						continue;
					else if(inputter.contains("levelName:")) {
						levelData.levelName = inputter.substring(10).trim();
					} else if(inputter.contains("firstRoom:")) {
						levelData.levelStartRoomName = inputter.substring(10).trim();
//						System.err.println("the default room name is: " + levelData.levelStartRoomName);
					} else if(inputter.contains("levelStartSpawnX:")) {
						levelData.levelStartX = Integer.parseInt(inputter.substring(17).trim());
					} else if(inputter.contains("levelStartSpawnY:")) {
						levelData.levelStartY = Integer.parseInt(inputter.substring(17).trim());
					} else if(inputter.contains("room:")) {
//						System.out.println("<><>DELME about to load a room...");
						RoomData newRoom = new RoomData(in, fileToLoad, levelData, ponyPanel, fromFiles);
						levelData.rooms.put(newRoom.getRoomName(), newRoom);
					} else if(inputter.contains("music:")) {
						if(inputter.equalsIgnoreCase("music:nomusic") || inputter.trim().equalsIgnoreCase("music:")) {
							levelData.bgm = null;
						} else if(inputter.equalsIgnoreCase("music:default")) {
							levelData.usingDefaultMusic = true;
						} else {
							if(fromFiles)
								levelData.bgm = new BackgroundMusic(inputter.substring(6), false);
							else
								levelData.bgm = new BackgroundMusic(inputter.substring(6));
						}
					} else if(inputter.contains("norain")) {
						levelData.shouldHaveRain = false;
					} else if(inputter.contains("rain")) {
						levelData.shouldHaveRain = true;
					}
					
					
//					System.err.println("the default room is null?  " + (levelData.rooms.get(levelData.levelStartRoomName) == null));
					
				} while((inputter = in.readLine()) != null);
				
				levelData.loadingComplete = true;
				
			} catch(Exception e) {
//				e.printStackTrace();
				levelData.levelLoadGotError = true;
			} finally {
				try { in.close(); } catch(Exception e) { 
					//e.printStackTrace();
					}
			}
			
			
		}
		
	}
	
	
	public static LevelData loadLevelThreaded(String fileToLoad, PonyPanel ponyPanel, boolean fromFiles) throws IOException {
		
		LevelData returnValue = new LevelData();
		
		BufferedReader in = null;
		
		if(fromFiles) {
			in = new BufferedReader(new FileReader(fileToLoad));
		} else {
			URL url = LevelData.class.getResource(fileToLoad);
//			if(url == null) {
//				System.out.println("<><>DELME okay, the URL was null for this: <<" + fileToLoad + ">>");
//			}
			in = new BufferedReader(new InputStreamReader(url.openStream()));
		}
		
		LevelLoadThread thread = new LevelLoadThread(in, returnValue, fromFiles, fileToLoad, ponyPanel);
		
		thread.start();
		
		return returnValue;
	}
	
	private LevelData() {
		rooms = new HashMap<String, RoomData>();
	}
	
	
	private void populateData(String fileToLoad, PonyPanel ponyPanel, boolean fromFiles) {
		
		fileName = fileToLoad;
		loadedFromFiles = fromFiles;
		rooms = new HashMap<String, RoomData>();
		
		BufferedReader in = null;
		
		try {
//			System.out.println("<><>DELME okay, let's see if it can find this: <<" + fileToLoad + ">>");
			if(fromFiles) {
				in = new BufferedReader(new FileReader(fileToLoad));
			} else {
				URL url = LevelData.class.getResource(fileToLoad);
//				if(url == null) {
//					System.out.println("<><>DELME okay, the URL was null for this: <<" + fileToLoad + ">>");
//				}
				in = new BufferedReader(new InputStreamReader(url.openStream()));
			}
			
			String inputter = in.readLine();
			
			if(inputter.equalsIgnoreCase("file")) {
				fromFiles = true;
			} else if(inputter.trim().equalsIgnoreCase("pack")) {
				
				//BOOKMARK
				
				JOptionPane.showMessageDialog(null, "<html>Program has detected that this is a packfile.<br><br>Please select a directory to unpack it into (this may take several minutes)</html>","",JOptionPane.INFORMATION_MESSAGE);
				
				JFileChooser fileChooser = new JFileChooser();
				fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				
				fileChooser.setMultiSelectionEnabled(false);
				
				int response = fileChooser.showSaveDialog(ponyPanel);
				
				if(response == JFileChooser.CANCEL_OPTION) {
					BusyPanel.hideWaitBox();
					return;
				}
					
				String targetDir = fileChooser.getSelectedFile().getAbsolutePath();
				
				PackerUnpacker unpacker = new PackerUnpacker();
				
				in.close();
				
				
				
				boolean unpackingWorked = unpacker.unpack(targetDir, fileToLoad);
				
				
				BusyPanel.hideWaitBox();
				
				
				if(unpackingWorked) {
					//JOptionPane.showMessageDialog(null, "<html>Unpacking was successful!<br><br>Now that the file has been unpacked,<br>please find the level file so it can be loaded!</html>","Unpacking succeeded",JOptionPane.INFORMATION_MESSAGE);
					
					
					populateData(unpacker.getMainFileName(), ponyPanel, true);
					
					
				}
				
				return;
				
			}
			
			boolean loadedCustomCharacters = false;
			
			shouldHaveRain = false;
			
			do {
				
				if(inputter.contains("#"))
					continue;
				else if(inputter.contains("levelName:")) {
					levelName = inputter.substring(10).trim();
				} else if(inputter.contains("firstRoom:")) {
					levelStartRoomName = inputter.substring(10).trim();
//					System.err.println("the default room name is: " + levelStartRoomName);
				} else if(inputter.contains("levelStartSpawnX:")) {
					levelStartX = Integer.parseInt(inputter.substring(17).trim());
				} else if(inputter.contains("levelStartSpawnY:")) {
					levelStartY = Integer.parseInt(inputter.substring(17).trim());
				} else if(inputter.contains("room:")) {
//					System.out.println("<><>DELME about to load a room...this from file: " + fileToLoad);
					RoomData newRoom = new RoomData(in, fileToLoad, this, ponyPanel, fromFiles);
					rooms.put(newRoom.getRoomName(), newRoom);
				} else if(inputter.contains("music:")) {
					if(inputter.equalsIgnoreCase("music:nomusic") || inputter.trim().equalsIgnoreCase("music:")) {
						bgm = null;
					} else if(inputter.equalsIgnoreCase("music:default")) {
						this.usingDefaultMusic = true;
					} else {
						if(fromFiles)
							bgm = new BackgroundMusic(inputter.substring(6), false);
						else
							bgm = new BackgroundMusic(inputter.substring(6));
					}
				} else if(inputter.contains("norain")) {
					shouldHaveRain = false;
				} else if(inputter.contains("rain")) {
					shouldHaveRain = true;
				} else if(inputter.trim().equalsIgnoreCase("characters:")) {
					ponyPanel.getPlayerSprite().loadCustomCharacters(in);
					loadedCustomCharacters = true;
				}
				
				
//				System.err.println("the default room is null?  " + (rooms.get(levelStartRoomName) == null));
				
			} while((inputter = in.readLine()) != null);
			
			if(!loadedCustomCharacters)
				ponyPanel.getPlayerSprite().loadingLevelNoCustomCharacters();
				
			
			loadingComplete = true;
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
//			System.out.println("<><>DELME about to exit; should do something better before we leave, here...");
			JOptionPane.showMessageDialog(null, "File not found: " + e.getMessage(),"File not found", JOptionPane.ERROR_MESSAGE);
			System.exit(1);
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
//			System.out.println("<><>DELME about to exit; should do something better before we leave, here...");
			JOptionPane.showMessageDialog(null, "Input/Output error: " + e.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
			System.exit(1);
		} catch(Exception e) {
//			e.printStackTrace();
//			System.out.println("<><>DELME about to exit; should do something better before we leave, here...");
			JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
			System.exit(1);
		} finally {
			if(in != null) {
				try {in.close();} catch(Exception e) {}
			}
		}
		
		
		
	}
	
	public LevelData(String fileToLoad, PonyPanel ponyPanel, boolean fromFiles) {
		
		
		populateData(fileToLoad, ponyPanel, fromFiles);
		
		
	}
	
	public RoomData getRoom(String roomName) {
		return rooms.get(roomName);
	}
	
	public String getName() {
		return levelName;
	}
	
	
	public void primeAll(Graphics g) {
		Set<String> roomNames = rooms.keySet();
		
		for(String roomName : roomNames) {
			RoomData rd = rooms.get(roomName);
			if(rd != null)
				rd.primeAll(g);
		}
	}

	public String getLevelStartRoomName() {
		return levelStartRoomName;
	}

	public int getLevelStartX() {
		return levelStartX;
	}

	public int getLevelStartY() {
		return levelStartY;
	}

	public BackgroundMusic getBgm() {
		if(usingDefaultMusic)
			return BackgroundMusic.getDefault();
		return bgm;
	}
	
	public boolean shouldHaveRain() {
		return shouldHaveRain;
	}
	
	public boolean levelLoadGotError() {
		return levelLoadGotError;
	}
	
	public boolean loadingComplete() {
		return loadingComplete;
	}
	
	
	public static void retrieveFileLengths(String fileToLoad, PonyPanel ponyPanel, HashMap<String, Long> fileLengths) {
		
		
//		HashMap<String, RoomData> rooms = new HashMap<String, RoomData>();
		
		BufferedReader in = null;
		
		try {
//			System.out.println("<><>DELME okay, let's see if it can find this: <<" + fileToLoad + ">>");
//			if(fromFiles) {
				in = new BufferedReader(new FileReader(fileToLoad));
//			} else {
//				URL url = LevelData.class.getResource(fileToLoad);
//				if(url == null) {
//					System.out.println("<><>DELME okay, the URL was null for this: <<" + fileToLoad + ">>");
//				}
//				in = new BufferedReader(new InputStreamReader(url.openStream()));
//			}
			
			String inputter = in.readLine();
			
			
			
//			shouldHaveRain = false;
			
			do {
				
				if(inputter.contains("#"))
					continue;
				else if(inputter.contains("levelName:")) {
//					levelName = inputter.substring(10).trim();
				} else if(inputter.contains("firstRoom:")) {
//					levelStartRoomName = inputter.substring(10).trim();
//					System.err.println("the default room name is: " + levelStartRoomName);
				} else if(inputter.contains("levelStartSpawnX:")) {
//					levelStartX = Integer.parseInt(inputter.substring(17).trim());
				} else if(inputter.contains("levelStartSpawnY:")) {
//					levelStartY = Integer.parseInt(inputter.substring(17).trim());
				} else if(inputter.contains("room:")) {
					
					//need to get the room's data
					
					RoomData.retrieveFileLengths(in, fileToLoad, null, ponyPanel, false, fileLengths);
					
//					System.out.println("<><>DELME about to load a room...");
//					RoomData newRoom = new RoomData(in, fileToLoad, this, ponyPanel, fromFiles);
//					rooms.put(newRoom.getRoomName(), newRoom);
				} else if(inputter.contains("music:")) {
					
					//need to get the BGM's data
					
					
					
					if(inputter.equalsIgnoreCase("music:nomusic") || inputter.trim().equalsIgnoreCase("music:")) {
//						bgm = null;
					} else if(inputter.equalsIgnoreCase("music:default")) {
//						this.usingDefaultMusic = true;
					} else {
						AudioManager.retrieveFileLength(inputter.substring(6), fileLengths);
//						bgm = new BackgroundMusic(inputter.substring(6));
					}
					
					
					
				} else if(inputter.contains("norain")) {
//					shouldHaveRain = false;
				} else if(inputter.contains("rain")) {
//					shouldHaveRain = true;
				}
				
				
//				System.err.println("the default room is null?  " + (rooms.get(levelStartRoomName) == null));
				
			} while((inputter = in.readLine()) != null);
			
//			loadingComplete = true;
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
//			System.out.println("<><>DELME about to exit; should do something better before we leave, here...");
			JOptionPane.showMessageDialog(null, "File not found: " + e.getMessage(),"File not found", JOptionPane.ERROR_MESSAGE);
			System.exit(1);
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
//			System.out.println("<><>DELME about to exit; should do something better before we leave, here...");
			JOptionPane.showMessageDialog(null, "Input/Output error: " + e.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
			System.exit(1);
		} catch(Exception e) {
//			e.printStackTrace();
//			System.out.println("<><>DELME about to exit; should do something better before we leave, here...");
			JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
			System.exit(1);
		} finally {
			if(in != null) {
				try {in.close();} catch(Exception e) {}
			}
		}
		
	}
	
	public String getFileName() {
		return fileName;
	}
	
	public boolean isFromFiles() {
		return loadedFromFiles;
	}
	
	public void soundOffAllRooms() {
		
		StringBuffer allRooms = new StringBuffer();
		allRooms.append("<html><><>DELME the size of the rooms: " + rooms.size());
		allRooms.append("<br><br>");
		
		Set<String> roomNames = rooms.keySet();
		
		for(String roomName : roomNames) {
			allRooms.append("A room name: <<" + roomName + ">><br>");
		}
		
		allRooms.append("</html>");
		
		JOptionPane.showMessageDialog(null, allRooms.toString());
		
	}
	
	public void resetAllGoals() {
		
		Set<String> roomNames = rooms.keySet();
		ArrayList<String> roomNamesSafe = new ArrayList<String>();
		roomNamesSafe.addAll(roomNames);
		
		RoomData rd = null;
		
		for(String roomName : roomNamesSafe) {
			rd = rooms.get(roomName);
			if(rd != null) {
				if(rd.getGoal() != null) {
					rd.getGoal().resetGoalButton();
				}
			}
		}
		
	}
	
	
	public static boolean checkLevelStartingPointDisplayDialogIfNot(String fileToLoad) {
		
		try {
			BufferedReader in = new BufferedReader(new FileReader(fileToLoad));
			
			String levelStartRoomName = null;
			int levelStartX = -1;
			int levelStartY = -1;
			
			String inputter = null;
			while((inputter = in.readLine()) != null) {
				
				if(inputter.contains("firstRoom:")) {
					levelStartRoomName = inputter.substring(10).trim();
		//			System.err.println("the default room name is: " + levelStartRoomName);
				} else if(inputter.contains("levelStartSpawnX:")) {
					levelStartX = Integer.parseInt(inputter.substring(17).trim());
				} else if(inputter.contains("levelStartSpawnY:")) {
					levelStartY = Integer.parseInt(inputter.substring(17).trim());
				}
			}
			
			if(levelStartX != -1 && levelStartY != -1 && levelStartRoomName != null)
				return true;
			
		} catch(Exception e) {
			String traceRaw = PonyPanel.formatStackTrace(e);
			
			traceRaw = traceRaw.replace("\n", "<br>");
			JOptionPane.showMessageDialog(null, "<html>An error occurred while checking to see if this file can be loaded:<br><br>"+traceRaw+"</html>","Error",JOptionPane.ERROR_MESSAGE);
		}
		
		JOptionPane.showMessageDialog(null, "Unable to find a starting point in this level; it cannot be loaded.","Unable to load file", JOptionPane.WARNING_MESSAGE);
		
		return false;
		
	}
	
	public void manageAudioLoading(String roomBeingLoaded) {
		
		
//		System.out.println("<><>DELME about to go into manageAudioLoading for room: " + roomBeingLoaded + "; purgeThread == null? " + (purgeThread == null ? "ya" : "no"));
		
		if(purgeThread != null) {
			purgeThread.interrupt();
			purgeThread = null;
		}
		
		purgeThread = new PurgeThread(rooms.get(roomBeingLoaded));
		Thread t = new Thread(purgeThread);
		t.start();
		
	}
	
	
	public class PurgeThread implements Runnable {
		
		private RoomData roomToBeSpared;
		
		private boolean shouldStop;
		
		public PurgeThread(RoomData r) {
			roomToBeSpared = r;
			shouldStop = false;
		}
		
		@Override
		public void run() {
			
//			System.out.println("<><>DELME now in run for purgeThread!  roomToBeSpared: " + ( roomToBeSpared == null ? "null" : roomToBeSpared.getRoomName()));
			
			ArrayList<RoomData> roomsToBePurged = new ArrayList<RoomData>();
			ArrayList<RoomData> roomsToBeLoaded = new ArrayList<RoomData>();
			
			Set<String> roomNames = rooms.keySet();
			
			for(String r : roomNames) {
				
				if(shouldStop) 
					return;
				
				
				if(roomToBeSpared == null || (!roomToBeSpared.getRoomName().equals(r) && !roomToBeSpared.connectsTo(r))) {
					roomsToBePurged.add(rooms.get(r));
				} else {
					roomsToBeLoaded.add(rooms.get(r));
				}
			}
			
//			System.out.println("<><>DELME lists populated; size of purge: " + roomsToBePurged.size() + ", size of load: " + roomsToBeLoaded.size());
			
			for(RoomData r : roomsToBeLoaded) {

				if(shouldStop) 
					return;
				
				r.loadAudio();
			}
			
			
			for(RoomData r : roomsToBePurged) {

				if(shouldStop) 
					return;
				
				r.purgeAudio();
			}
			
		}
		
		public void interrupt() {
			shouldStop = true;
		}
		
	}
	
}
